package zio.aws.config.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ResourceValue(value: zio.aws.config.model.ResourceValueType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ResourceValue = {
    import ResourceValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ResourceValue
      .builder()
      .value(value.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.config.model.ResourceValue.ReadOnly =
    zio.aws.config.model.ResourceValue.wrap(buildAwsValue())
}
object ResourceValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ResourceValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ResourceValue =
      zio.aws.config.model.ResourceValue(value)
    def value: zio.aws.config.model.ResourceValueType
    def getValue: ZIO[Any, Nothing, zio.aws.config.model.ResourceValueType] =
      ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ResourceValue
  ) extends zio.aws.config.model.ResourceValue.ReadOnly {
    override val value: zio.aws.config.model.ResourceValueType =
      zio.aws.config.model.ResourceValueType.wrap(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ResourceValue
  ): zio.aws.config.model.ResourceValue.ReadOnly = new Wrapper(impl)
}
