package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetComplianceDetailsByResourceResponse(
    evaluationResults: Optional[
      Iterable[zio.aws.config.model.EvaluationResult]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceResponse = {
    import GetComplianceDetailsByResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceResponse
      .builder()
      .optionallyWith(
        evaluationResults.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.evaluationResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.GetComplianceDetailsByResourceResponse.ReadOnly =
    zio.aws.config.model.GetComplianceDetailsByResourceResponse
      .wrap(buildAwsValue())
}
object GetComplianceDetailsByResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.GetComplianceDetailsByResourceResponse =
      zio.aws.config.model.GetComplianceDetailsByResourceResponse(
        evaluationResults.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def evaluationResults
        : Optional[List[zio.aws.config.model.EvaluationResult.ReadOnly]]
    def nextToken: Optional[String]
    def getEvaluationResults: ZIO[Any, AwsError, List[
      zio.aws.config.model.EvaluationResult.ReadOnly
    ]] = AwsError.unwrapOptionField("evaluationResults", evaluationResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceResponse
  ) extends zio.aws.config.model.GetComplianceDetailsByResourceResponse.ReadOnly {
    override val evaluationResults
        : Optional[List[zio.aws.config.model.EvaluationResult.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evaluationResults())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.EvaluationResult.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceResponse
  ): zio.aws.config.model.GetComplianceDetailsByResourceResponse.ReadOnly =
    new Wrapper(impl)
}
