package zio.aws.config.model
import zio.prelude.data.Optional
import zio.aws.config.model.primitives.DescribePendingAggregationRequestsLimit
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribePendingAggregationRequestsRequest(
    limit: Optional[DescribePendingAggregationRequestsLimit] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsRequest = {
    import DescribePendingAggregationRequestsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsRequest
      .builder()
      .optionallyWith(
        limit.map(value =>
          DescribePendingAggregationRequestsLimit.unwrap(value): Integer
        )
      )(_.limit)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribePendingAggregationRequestsRequest.ReadOnly =
    zio.aws.config.model.DescribePendingAggregationRequestsRequest
      .wrap(buildAwsValue())
}
object DescribePendingAggregationRequestsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.DescribePendingAggregationRequestsRequest =
      zio.aws.config.model.DescribePendingAggregationRequestsRequest(
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def limit: Optional[DescribePendingAggregationRequestsLimit]
    def nextToken: Optional[String]
    def getLimit: ZIO[Any, AwsError, DescribePendingAggregationRequestsLimit] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsRequest
  ) extends zio.aws.config.model.DescribePendingAggregationRequestsRequest.ReadOnly {
    override val limit: Optional[DescribePendingAggregationRequestsLimit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.limit())
        .map(value =>
          zio.aws.config.model.primitives
            .DescribePendingAggregationRequestsLimit(value)
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsRequest
  ): zio.aws.config.model.DescribePendingAggregationRequestsRequest.ReadOnly =
    new Wrapper(impl)
}
