package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeOrganizationConformancePackStatusesResponse(
    organizationConformancePackStatuses: Optional[
      Iterable[zio.aws.config.model.OrganizationConformancePackStatus]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesResponse = {
    import DescribeOrganizationConformancePackStatusesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesResponse
      .builder()
      .optionallyWith(
        organizationConformancePackStatuses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.organizationConformancePackStatuses)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeOrganizationConformancePackStatusesResponse.ReadOnly =
    zio.aws.config.model.DescribeOrganizationConformancePackStatusesResponse
      .wrap(buildAwsValue())
}
object DescribeOrganizationConformancePackStatusesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.DescribeOrganizationConformancePackStatusesResponse =
      zio.aws.config.model.DescribeOrganizationConformancePackStatusesResponse(
        organizationConformancePackStatuses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def organizationConformancePackStatuses: Optional[
      List[zio.aws.config.model.OrganizationConformancePackStatus.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getOrganizationConformancePackStatuses: ZIO[Any, AwsError, List[
      zio.aws.config.model.OrganizationConformancePackStatus.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "organizationConformancePackStatuses",
      organizationConformancePackStatuses
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesResponse
  ) extends zio.aws.config.model.DescribeOrganizationConformancePackStatusesResponse.ReadOnly {
    override val organizationConformancePackStatuses: Optional[
      List[zio.aws.config.model.OrganizationConformancePackStatus.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.organizationConformancePackStatuses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.OrganizationConformancePackStatus.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesResponse
  ): zio.aws.config.model.DescribeOrganizationConformancePackStatusesResponse.ReadOnly =
    new Wrapper(impl)
}
