package zio.aws.config.model
import scala.jdk.CollectionConverters.*
sealed trait OrganizationConfigRuleTriggerType {
  def unwrap: software.amazon.awssdk.services.config.model.OrganizationConfigRuleTriggerType
}
object OrganizationConfigRuleTriggerType {
  def wrap(
      value: software.amazon.awssdk.services.config.model.OrganizationConfigRuleTriggerType
  ): zio.aws.config.model.OrganizationConfigRuleTriggerType = value match {
    case software.amazon.awssdk.services.config.model.OrganizationConfigRuleTriggerType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.config.model.OrganizationConfigRuleTriggerType.CONFIGURATION_ITEM_CHANGE_NOTIFICATION =>
      val r = ConfigurationItemChangeNotification
      r
    case software.amazon.awssdk.services.config.model.OrganizationConfigRuleTriggerType.OVERSIZED_CONFIGURATION_ITEM_CHANGE_NOTIFICATION =>
      val r = OversizedConfigurationItemChangeNotification
      r
    case software.amazon.awssdk.services.config.model.OrganizationConfigRuleTriggerType.SCHEDULED_NOTIFICATION =>
      val r = ScheduledNotification
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.config.model.OrganizationConfigRuleTriggerType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.OrganizationConfigRuleTriggerType =
      software.amazon.awssdk.services.config.model.OrganizationConfigRuleTriggerType.UNKNOWN_TO_SDK_VERSION
  }
  case object ConfigurationItemChangeNotification
      extends zio.aws.config.model.OrganizationConfigRuleTriggerType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.OrganizationConfigRuleTriggerType =
      software.amazon.awssdk.services.config.model.OrganizationConfigRuleTriggerType.CONFIGURATION_ITEM_CHANGE_NOTIFICATION
  }
  case object OversizedConfigurationItemChangeNotification
      extends zio.aws.config.model.OrganizationConfigRuleTriggerType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.OrganizationConfigRuleTriggerType =
      software.amazon.awssdk.services.config.model.OrganizationConfigRuleTriggerType.OVERSIZED_CONFIGURATION_ITEM_CHANGE_NOTIFICATION
  }
  case object ScheduledNotification
      extends zio.aws.config.model.OrganizationConfigRuleTriggerType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.OrganizationConfigRuleTriggerType =
      software.amazon.awssdk.services.config.model.OrganizationConfigRuleTriggerType.SCHEDULED_NOTIFICATION
  }
}
