package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetAggregateResourceConfigResponse(
    configurationItem: Optional[zio.aws.config.model.ConfigurationItem] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.GetAggregateResourceConfigResponse = {
    import GetAggregateResourceConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.GetAggregateResourceConfigResponse
      .builder()
      .optionallyWith(configurationItem.map(value => value.buildAwsValue()))(
        _.configurationItem
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.GetAggregateResourceConfigResponse.ReadOnly =
    zio.aws.config.model.GetAggregateResourceConfigResponse
      .wrap(buildAwsValue())
}
object GetAggregateResourceConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.GetAggregateResourceConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.GetAggregateResourceConfigResponse =
      zio.aws.config.model.GetAggregateResourceConfigResponse(
        configurationItem.map(value => value.asEditable)
      )
    def configurationItem
        : Optional[zio.aws.config.model.ConfigurationItem.ReadOnly]
    def getConfigurationItem
        : ZIO[Any, AwsError, zio.aws.config.model.ConfigurationItem.ReadOnly] =
      AwsError.unwrapOptionField("configurationItem", configurationItem)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.GetAggregateResourceConfigResponse
  ) extends zio.aws.config.model.GetAggregateResourceConfigResponse.ReadOnly {
    override val configurationItem
        : Optional[zio.aws.config.model.ConfigurationItem.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurationItem())
        .map(value => zio.aws.config.model.ConfigurationItem.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.GetAggregateResourceConfigResponse
  ): zio.aws.config.model.GetAggregateResourceConfigResponse.ReadOnly =
    new Wrapper(impl)
}
