package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FailedRemediationBatch(
    failureMessage: Optional[String] = Optional.Absent,
    failedItems: Optional[
      Iterable[zio.aws.config.model.RemediationConfiguration]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.FailedRemediationBatch = {
    import FailedRemediationBatch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.FailedRemediationBatch
      .builder()
      .optionallyWith(failureMessage.map(value => value: java.lang.String))(
        _.failureMessage
      )
      .optionallyWith(
        failedItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failedItems)
      .build()
  }
  def asReadOnly: zio.aws.config.model.FailedRemediationBatch.ReadOnly =
    zio.aws.config.model.FailedRemediationBatch.wrap(buildAwsValue())
}
object FailedRemediationBatch {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.FailedRemediationBatch
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.FailedRemediationBatch =
      zio.aws.config.model.FailedRemediationBatch(
        failureMessage.map(value => value),
        failedItems.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def failureMessage: Optional[String]
    def failedItems
        : Optional[List[zio.aws.config.model.RemediationConfiguration.ReadOnly]]
    def getFailureMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("failureMessage", failureMessage)
    def getFailedItems: ZIO[Any, AwsError, List[
      zio.aws.config.model.RemediationConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("failedItems", failedItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.FailedRemediationBatch
  ) extends zio.aws.config.model.FailedRemediationBatch.ReadOnly {
    override val failureMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.failureMessage())
      .map(value => value: String)
    override val failedItems: Optional[
      List[zio.aws.config.model.RemediationConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.failedItems())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.RemediationConfiguration.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.FailedRemediationBatch
  ): zio.aws.config.model.FailedRemediationBatch.ReadOnly = new Wrapper(impl)
}
