package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeConfigRulesFilters(
    evaluationMode: Optional[zio.aws.config.model.EvaluationMode] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeConfigRulesFilters = {
    import DescribeConfigRulesFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeConfigRulesFilters
      .builder()
      .optionallyWith(evaluationMode.map(value => value.unwrap))(
        _.evaluationMode
      )
      .build()
  }
  def asReadOnly: zio.aws.config.model.DescribeConfigRulesFilters.ReadOnly =
    zio.aws.config.model.DescribeConfigRulesFilters.wrap(buildAwsValue())
}
object DescribeConfigRulesFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeConfigRulesFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.DescribeConfigRulesFilters =
      zio.aws.config.model
        .DescribeConfigRulesFilters(evaluationMode.map(value => value))
    def evaluationMode: Optional[zio.aws.config.model.EvaluationMode]
    def getEvaluationMode
        : ZIO[Any, AwsError, zio.aws.config.model.EvaluationMode] =
      AwsError.unwrapOptionField("evaluationMode", evaluationMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeConfigRulesFilters
  ) extends zio.aws.config.model.DescribeConfigRulesFilters.ReadOnly {
    override val evaluationMode: Optional[zio.aws.config.model.EvaluationMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evaluationMode())
        .map(value => zio.aws.config.model.EvaluationMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeConfigRulesFilters
  ): zio.aws.config.model.DescribeConfigRulesFilters.ReadOnly = new Wrapper(
    impl
  )
}
