package zio.aws.config.model
import scala.jdk.CollectionConverters.*
sealed trait ConformancePackState {
  def unwrap: software.amazon.awssdk.services.config.model.ConformancePackState
}
object ConformancePackState {
  def wrap(
      value: software.amazon.awssdk.services.config.model.ConformancePackState
  ): zio.aws.config.model.ConformancePackState = value match {
    case software.amazon.awssdk.services.config.model.ConformancePackState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.config.model.ConformancePackState.CREATE_IN_PROGRESS =>
      val r = CREATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.config.model.ConformancePackState.CREATE_COMPLETE =>
      val r = CREATE_COMPLETE
      r
    case software.amazon.awssdk.services.config.model.ConformancePackState.CREATE_FAILED =>
      val r = CREATE_FAILED
      r
    case software.amazon.awssdk.services.config.model.ConformancePackState.DELETE_IN_PROGRESS =>
      val r = DELETE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.config.model.ConformancePackState.DELETE_FAILED =>
      val r = DELETE_FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.config.model.ConformancePackState {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ConformancePackState =
      software.amazon.awssdk.services.config.model.ConformancePackState.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATE_IN_PROGRESS
      extends zio.aws.config.model.ConformancePackState {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ConformancePackState =
      software.amazon.awssdk.services.config.model.ConformancePackState.CREATE_IN_PROGRESS
  }
  case object CREATE_COMPLETE
      extends zio.aws.config.model.ConformancePackState {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ConformancePackState =
      software.amazon.awssdk.services.config.model.ConformancePackState.CREATE_COMPLETE
  }
  case object CREATE_FAILED extends zio.aws.config.model.ConformancePackState {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ConformancePackState =
      software.amazon.awssdk.services.config.model.ConformancePackState.CREATE_FAILED
  }
  case object DELETE_IN_PROGRESS
      extends zio.aws.config.model.ConformancePackState {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ConformancePackState =
      software.amazon.awssdk.services.config.model.ConformancePackState.DELETE_IN_PROGRESS
  }
  case object DELETE_FAILED extends zio.aws.config.model.ConformancePackState {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ConformancePackState =
      software.amazon.awssdk.services.config.model.ConformancePackState.DELETE_FAILED
  }
}
