package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListResourceEvaluationsResponse(
    resourceEvaluations: Optional[
      Iterable[zio.aws.config.model.ResourceEvaluation]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ListResourceEvaluationsResponse = {
    import ListResourceEvaluationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ListResourceEvaluationsResponse
      .builder()
      .optionallyWith(
        resourceEvaluations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceEvaluations)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.ListResourceEvaluationsResponse.ReadOnly =
    zio.aws.config.model.ListResourceEvaluationsResponse.wrap(buildAwsValue())
}
object ListResourceEvaluationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ListResourceEvaluationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ListResourceEvaluationsResponse =
      zio.aws.config.model.ListResourceEvaluationsResponse(
        resourceEvaluations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def resourceEvaluations
        : Optional[List[zio.aws.config.model.ResourceEvaluation.ReadOnly]]
    def nextToken: Optional[String]
    def getResourceEvaluations: ZIO[Any, AwsError, List[
      zio.aws.config.model.ResourceEvaluation.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceEvaluations", resourceEvaluations)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ListResourceEvaluationsResponse
  ) extends zio.aws.config.model.ListResourceEvaluationsResponse.ReadOnly {
    override val resourceEvaluations
        : Optional[List[zio.aws.config.model.ResourceEvaluation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceEvaluations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.ResourceEvaluation.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ListResourceEvaluationsResponse
  ): zio.aws.config.model.ListResourceEvaluationsResponse.ReadOnly =
    new Wrapper(impl)
}
