package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{
  ResourceConfiguration,
  StringWithCharLimit256,
  BaseResourceId
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ResourceDetails(
    resourceId: BaseResourceId,
    resourceType: StringWithCharLimit256,
    resourceConfiguration: ResourceConfiguration,
    resourceConfigurationSchemaType: Optional[
      zio.aws.config.model.ResourceConfigurationSchemaType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ResourceDetails = {
    import ResourceDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ResourceDetails
      .builder()
      .resourceId(BaseResourceId.unwrap(resourceId): java.lang.String)
      .resourceType(
        StringWithCharLimit256.unwrap(resourceType): java.lang.String
      )
      .resourceConfiguration(
        ResourceConfiguration.unwrap(resourceConfiguration): java.lang.String
      )
      .optionallyWith(
        resourceConfigurationSchemaType.map(value => value.unwrap)
      )(_.resourceConfigurationSchemaType)
      .build()
  }
  def asReadOnly: zio.aws.config.model.ResourceDetails.ReadOnly =
    zio.aws.config.model.ResourceDetails.wrap(buildAwsValue())
}
object ResourceDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ResourceDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ResourceDetails =
      zio.aws.config.model.ResourceDetails(
        resourceId,
        resourceType,
        resourceConfiguration,
        resourceConfigurationSchemaType.map(value => value)
      )
    def resourceId: BaseResourceId
    def resourceType: StringWithCharLimit256
    def resourceConfiguration: ResourceConfiguration
    def resourceConfigurationSchemaType
        : Optional[zio.aws.config.model.ResourceConfigurationSchemaType]
    def getResourceId: ZIO[Any, Nothing, BaseResourceId] =
      ZIO.succeed(resourceId)
    def getResourceType: ZIO[Any, Nothing, StringWithCharLimit256] =
      ZIO.succeed(resourceType)
    def getResourceConfiguration: ZIO[Any, Nothing, ResourceConfiguration] =
      ZIO.succeed(resourceConfiguration)
    def getResourceConfigurationSchemaType: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.ResourceConfigurationSchemaType
    ] = AwsError.unwrapOptionField(
      "resourceConfigurationSchemaType",
      resourceConfigurationSchemaType
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ResourceDetails
  ) extends zio.aws.config.model.ResourceDetails.ReadOnly {
    override val resourceId: BaseResourceId =
      zio.aws.config.model.primitives.BaseResourceId(impl.resourceId())
    override val resourceType: StringWithCharLimit256 =
      zio.aws.config.model.primitives
        .StringWithCharLimit256(impl.resourceType())
    override val resourceConfiguration: ResourceConfiguration =
      zio.aws.config.model.primitives
        .ResourceConfiguration(impl.resourceConfiguration())
    override val resourceConfigurationSchemaType
        : Optional[zio.aws.config.model.ResourceConfigurationSchemaType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceConfigurationSchemaType())
        .map(value =>
          zio.aws.config.model.ResourceConfigurationSchemaType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ResourceDetails
  ): zio.aws.config.model.ResourceDetails.ReadOnly = new Wrapper(impl)
}
