package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeRemediationExecutionStatusResponse(
    remediationExecutionStatuses: Optional[
      Iterable[zio.aws.config.model.RemediationExecutionStatus]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusResponse = {
    import DescribeRemediationExecutionStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusResponse
      .builder()
      .optionallyWith(
        remediationExecutionStatuses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.remediationExecutionStatuses)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeRemediationExecutionStatusResponse.ReadOnly =
    zio.aws.config.model.DescribeRemediationExecutionStatusResponse
      .wrap(buildAwsValue())
}
object DescribeRemediationExecutionStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.DescribeRemediationExecutionStatusResponse =
      zio.aws.config.model.DescribeRemediationExecutionStatusResponse(
        remediationExecutionStatuses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def remediationExecutionStatuses: Optional[
      List[zio.aws.config.model.RemediationExecutionStatus.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getRemediationExecutionStatuses: ZIO[Any, AwsError, List[
      zio.aws.config.model.RemediationExecutionStatus.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "remediationExecutionStatuses",
      remediationExecutionStatuses
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusResponse
  ) extends zio.aws.config.model.DescribeRemediationExecutionStatusResponse.ReadOnly {
    override val remediationExecutionStatuses: Optional[
      List[zio.aws.config.model.RemediationExecutionStatus.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.remediationExecutionStatuses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.RemediationExecutionStatus.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusResponse
  ): zio.aws.config.model.DescribeRemediationExecutionStatusResponse.ReadOnly =
    new Wrapper(impl)
}
