package zio.aws.config.model
import scala.jdk.CollectionConverters.*
sealed trait ResourceEvaluationStatus {
  def unwrap
      : software.amazon.awssdk.services.config.model.ResourceEvaluationStatus
}
object ResourceEvaluationStatus {
  def wrap(
      value: software.amazon.awssdk.services.config.model.ResourceEvaluationStatus
  ): zio.aws.config.model.ResourceEvaluationStatus = value match {
    case software.amazon.awssdk.services.config.model.ResourceEvaluationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.config.model.ResourceEvaluationStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.config.model.ResourceEvaluationStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.config.model.ResourceEvaluationStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.config.model.ResourceEvaluationStatus {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceEvaluationStatus =
      software.amazon.awssdk.services.config.model.ResourceEvaluationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object IN_PROGRESS
      extends zio.aws.config.model.ResourceEvaluationStatus {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceEvaluationStatus =
      software.amazon.awssdk.services.config.model.ResourceEvaluationStatus.IN_PROGRESS
  }
  case object FAILED extends zio.aws.config.model.ResourceEvaluationStatus {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceEvaluationStatus =
      software.amazon.awssdk.services.config.model.ResourceEvaluationStatus.FAILED
  }
  case object SUCCEEDED extends zio.aws.config.model.ResourceEvaluationStatus {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceEvaluationStatus =
      software.amazon.awssdk.services.config.model.ResourceEvaluationStatus.SUCCEEDED
  }
}
