package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.EvaluationContextIdentifier
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ResourceEvaluationFilters(
    evaluationMode: Optional[zio.aws.config.model.EvaluationMode] =
      Optional.Absent,
    timeWindow: Optional[zio.aws.config.model.TimeWindow] = Optional.Absent,
    evaluationContextIdentifier: Optional[EvaluationContextIdentifier] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ResourceEvaluationFilters = {
    import ResourceEvaluationFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ResourceEvaluationFilters
      .builder()
      .optionallyWith(evaluationMode.map(value => value.unwrap))(
        _.evaluationMode
      )
      .optionallyWith(timeWindow.map(value => value.buildAwsValue()))(
        _.timeWindow
      )
      .optionallyWith(
        evaluationContextIdentifier.map(value =>
          EvaluationContextIdentifier.unwrap(value): java.lang.String
        )
      )(_.evaluationContextIdentifier)
      .build()
  }
  def asReadOnly: zio.aws.config.model.ResourceEvaluationFilters.ReadOnly =
    zio.aws.config.model.ResourceEvaluationFilters.wrap(buildAwsValue())
}
object ResourceEvaluationFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ResourceEvaluationFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ResourceEvaluationFilters =
      zio.aws.config.model.ResourceEvaluationFilters(
        evaluationMode.map(value => value),
        timeWindow.map(value => value.asEditable),
        evaluationContextIdentifier.map(value => value)
      )
    def evaluationMode: Optional[zio.aws.config.model.EvaluationMode]
    def timeWindow: Optional[zio.aws.config.model.TimeWindow.ReadOnly]
    def evaluationContextIdentifier: Optional[EvaluationContextIdentifier]
    def getEvaluationMode
        : ZIO[Any, AwsError, zio.aws.config.model.EvaluationMode] =
      AwsError.unwrapOptionField("evaluationMode", evaluationMode)
    def getTimeWindow
        : ZIO[Any, AwsError, zio.aws.config.model.TimeWindow.ReadOnly] =
      AwsError.unwrapOptionField("timeWindow", timeWindow)
    def getEvaluationContextIdentifier
        : ZIO[Any, AwsError, EvaluationContextIdentifier] =
      AwsError.unwrapOptionField(
        "evaluationContextIdentifier",
        evaluationContextIdentifier
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ResourceEvaluationFilters
  ) extends zio.aws.config.model.ResourceEvaluationFilters.ReadOnly {
    override val evaluationMode: Optional[zio.aws.config.model.EvaluationMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evaluationMode())
        .map(value => zio.aws.config.model.EvaluationMode.wrap(value))
    override val timeWindow
        : Optional[zio.aws.config.model.TimeWindow.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeWindow())
        .map(value => zio.aws.config.model.TimeWindow.wrap(value))
    override val evaluationContextIdentifier
        : Optional[EvaluationContextIdentifier] = zio.aws.core.internal
      .optionalFromNullable(impl.evaluationContextIdentifier())
      .map(value =>
        zio.aws.config.model.primitives.EvaluationContextIdentifier(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ResourceEvaluationFilters
  ): zio.aws.config.model.ResourceEvaluationFilters.ReadOnly = new Wrapper(impl)
}
