package zio.aws.config.model
import scala.jdk.CollectionConverters.*
sealed trait RecorderStatus {
  def unwrap: software.amazon.awssdk.services.config.model.RecorderStatus
}
object RecorderStatus {
  def wrap(
      value: software.amazon.awssdk.services.config.model.RecorderStatus
  ): zio.aws.config.model.RecorderStatus = value match {
    case software.amazon.awssdk.services.config.model.RecorderStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.config.model.RecorderStatus.PENDING =>
      val r = Pending
      r
    case software.amazon.awssdk.services.config.model.RecorderStatus.SUCCESS =>
      val r = Success
      r
    case software.amazon.awssdk.services.config.model.RecorderStatus.FAILURE =>
      val r = Failure
      r
  }
  case object unknownToSdkVersion extends zio.aws.config.model.RecorderStatus {
    override def unwrap
        : software.amazon.awssdk.services.config.model.RecorderStatus =
      software.amazon.awssdk.services.config.model.RecorderStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Pending extends zio.aws.config.model.RecorderStatus {
    override def unwrap
        : software.amazon.awssdk.services.config.model.RecorderStatus =
      software.amazon.awssdk.services.config.model.RecorderStatus.PENDING
  }
  case object Success extends zio.aws.config.model.RecorderStatus {
    override def unwrap
        : software.amazon.awssdk.services.config.model.RecorderStatus =
      software.amazon.awssdk.services.config.model.RecorderStatus.SUCCESS
  }
  case object Failure extends zio.aws.config.model.RecorderStatus {
    override def unwrap
        : software.amazon.awssdk.services.config.model.RecorderStatus =
      software.amazon.awssdk.services.config.model.RecorderStatus.FAILURE
  }
}
