package zio.aws.config.model
import zio.prelude.data.Optional
import zio.aws.config.model.primitives.ListResourceEvaluationsPageItemLimit
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListResourceEvaluationsRequest(
    filters: Optional[zio.aws.config.model.ResourceEvaluationFilters] =
      Optional.Absent,
    limit: Optional[ListResourceEvaluationsPageItemLimit] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ListResourceEvaluationsRequest = {
    import ListResourceEvaluationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ListResourceEvaluationsRequest
      .builder()
      .optionallyWith(filters.map(value => value.buildAwsValue()))(_.filters)
      .optionallyWith(
        limit.map(value =>
          ListResourceEvaluationsPageItemLimit.unwrap(value): Integer
        )
      )(_.limit)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.config.model.ListResourceEvaluationsRequest.ReadOnly =
    zio.aws.config.model.ListResourceEvaluationsRequest.wrap(buildAwsValue())
}
object ListResourceEvaluationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ListResourceEvaluationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ListResourceEvaluationsRequest =
      zio.aws.config.model.ListResourceEvaluationsRequest(
        filters.map(value => value.asEditable),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def filters
        : Optional[zio.aws.config.model.ResourceEvaluationFilters.ReadOnly]
    def limit: Optional[ListResourceEvaluationsPageItemLimit]
    def nextToken: Optional[String]
    def getFilters: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.ResourceEvaluationFilters.ReadOnly
    ] = AwsError.unwrapOptionField("filters", filters)
    def getLimit: ZIO[Any, AwsError, ListResourceEvaluationsPageItemLimit] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ListResourceEvaluationsRequest
  ) extends zio.aws.config.model.ListResourceEvaluationsRequest.ReadOnly {
    override val filters
        : Optional[zio.aws.config.model.ResourceEvaluationFilters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          zio.aws.config.model.ResourceEvaluationFilters.wrap(value)
        )
    override val limit: Optional[ListResourceEvaluationsPageItemLimit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.limit())
        .map(value =>
          zio.aws.config.model.primitives
            .ListResourceEvaluationsPageItemLimit(value)
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ListResourceEvaluationsRequest
  ): zio.aws.config.model.ListResourceEvaluationsRequest.ReadOnly = new Wrapper(
    impl
  )
}
