package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListConformancePackComplianceScoresResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    conformancePackComplianceScores: Iterable[
      zio.aws.config.model.ConformancePackComplianceScore
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ListConformancePackComplianceScoresResponse = {
    import ListConformancePackComplianceScoresResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ListConformancePackComplianceScoresResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .conformancePackComplianceScores(conformancePackComplianceScores.map {
        item =>
          item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.ListConformancePackComplianceScoresResponse.ReadOnly =
    zio.aws.config.model.ListConformancePackComplianceScoresResponse
      .wrap(buildAwsValue())
}
object ListConformancePackComplianceScoresResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ListConformancePackComplianceScoresResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.ListConformancePackComplianceScoresResponse =
      zio.aws.config.model.ListConformancePackComplianceScoresResponse(
        nextToken.map(value => value),
        conformancePackComplianceScores.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[NextToken]
    def conformancePackComplianceScores
        : List[zio.aws.config.model.ConformancePackComplianceScore.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getConformancePackComplianceScores: ZIO[Any, Nothing, List[
      zio.aws.config.model.ConformancePackComplianceScore.ReadOnly
    ]] = ZIO.succeed(conformancePackComplianceScores)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ListConformancePackComplianceScoresResponse
  ) extends zio.aws.config.model.ListConformancePackComplianceScoresResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.config.model.primitives.NextToken(value))
    override val conformancePackComplianceScores
        : List[zio.aws.config.model.ConformancePackComplianceScore.ReadOnly] =
      impl
        .conformancePackComplianceScores()
        .asScala
        .map { item =>
          zio.aws.config.model.ConformancePackComplianceScore.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ListConformancePackComplianceScoresResponse
  ): zio.aws.config.model.ListConformancePackComplianceScoresResponse.ReadOnly =
    new Wrapper(impl)
}
