package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.ConfigRuleName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetCustomRulePolicyRequest(
    configRuleName: Optional[ConfigRuleName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.GetCustomRulePolicyRequest = {
    import GetCustomRulePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.GetCustomRulePolicyRequest
      .builder()
      .optionallyWith(
        configRuleName.map(value =>
          ConfigRuleName.unwrap(value): java.lang.String
        )
      )(_.configRuleName)
      .build()
  }
  def asReadOnly: zio.aws.config.model.GetCustomRulePolicyRequest.ReadOnly =
    zio.aws.config.model.GetCustomRulePolicyRequest.wrap(buildAwsValue())
}
object GetCustomRulePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.GetCustomRulePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.GetCustomRulePolicyRequest =
      zio.aws.config.model
        .GetCustomRulePolicyRequest(configRuleName.map(value => value))
    def configRuleName: Optional[ConfigRuleName]
    def getConfigRuleName: ZIO[Any, AwsError, ConfigRuleName] =
      AwsError.unwrapOptionField("configRuleName", configRuleName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.GetCustomRulePolicyRequest
  ) extends zio.aws.config.model.GetCustomRulePolicyRequest.ReadOnly {
    override val configRuleName: Optional[ConfigRuleName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configRuleName())
        .map(value => zio.aws.config.model.primitives.ConfigRuleName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.GetCustomRulePolicyRequest
  ): zio.aws.config.model.GetCustomRulePolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
