package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetAggregateComplianceDetailsByConfigRuleResponse(
    aggregateEvaluationResults: Optional[
      Iterable[zio.aws.config.model.AggregateEvaluationResult]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleResponse = {
    import GetAggregateComplianceDetailsByConfigRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleResponse
      .builder()
      .optionallyWith(
        aggregateEvaluationResults.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.aggregateEvaluationResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.GetAggregateComplianceDetailsByConfigRuleResponse.ReadOnly =
    zio.aws.config.model.GetAggregateComplianceDetailsByConfigRuleResponse
      .wrap(buildAwsValue())
}
object GetAggregateComplianceDetailsByConfigRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.GetAggregateComplianceDetailsByConfigRuleResponse =
      zio.aws.config.model.GetAggregateComplianceDetailsByConfigRuleResponse(
        aggregateEvaluationResults.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def aggregateEvaluationResults: Optional[
      List[zio.aws.config.model.AggregateEvaluationResult.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getAggregateEvaluationResults: ZIO[Any, AwsError, List[
      zio.aws.config.model.AggregateEvaluationResult.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "aggregateEvaluationResults",
      aggregateEvaluationResults
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleResponse
  ) extends zio.aws.config.model.GetAggregateComplianceDetailsByConfigRuleResponse.ReadOnly {
    override val aggregateEvaluationResults: Optional[
      List[zio.aws.config.model.AggregateEvaluationResult.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.aggregateEvaluationResults())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.AggregateEvaluationResult.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.config.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleResponse
  ): zio.aws.config.model.GetAggregateComplianceDetailsByConfigRuleResponse.ReadOnly =
    new Wrapper(impl)
}
