package zio.aws.config.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.config.model.primitives.Date
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ConfigExportDeliveryInfo(
    lastStatus: Optional[zio.aws.config.model.DeliveryStatus] = Optional.Absent,
    lastErrorCode: Optional[String] = Optional.Absent,
    lastErrorMessage: Optional[String] = Optional.Absent,
    lastAttemptTime: Optional[Date] = Optional.Absent,
    lastSuccessfulTime: Optional[Date] = Optional.Absent,
    nextDeliveryTime: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ConfigExportDeliveryInfo = {
    import ConfigExportDeliveryInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ConfigExportDeliveryInfo
      .builder()
      .optionallyWith(lastStatus.map(value => value.unwrap))(_.lastStatus)
      .optionallyWith(lastErrorCode.map(value => value: java.lang.String))(
        _.lastErrorCode
      )
      .optionallyWith(lastErrorMessage.map(value => value: java.lang.String))(
        _.lastErrorMessage
      )
      .optionallyWith(
        lastAttemptTime.map(value => Date.unwrap(value): Instant)
      )(_.lastAttemptTime)
      .optionallyWith(
        lastSuccessfulTime.map(value => Date.unwrap(value): Instant)
      )(_.lastSuccessfulTime)
      .optionallyWith(
        nextDeliveryTime.map(value => Date.unwrap(value): Instant)
      )(_.nextDeliveryTime)
      .build()
  }
  def asReadOnly: zio.aws.config.model.ConfigExportDeliveryInfo.ReadOnly =
    zio.aws.config.model.ConfigExportDeliveryInfo.wrap(buildAwsValue())
}
object ConfigExportDeliveryInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ConfigExportDeliveryInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ConfigExportDeliveryInfo =
      zio.aws.config.model.ConfigExportDeliveryInfo(
        lastStatus.map(value => value),
        lastErrorCode.map(value => value),
        lastErrorMessage.map(value => value),
        lastAttemptTime.map(value => value),
        lastSuccessfulTime.map(value => value),
        nextDeliveryTime.map(value => value)
      )
    def lastStatus: Optional[zio.aws.config.model.DeliveryStatus]
    def lastErrorCode: Optional[String]
    def lastErrorMessage: Optional[String]
    def lastAttemptTime: Optional[Date]
    def lastSuccessfulTime: Optional[Date]
    def nextDeliveryTime: Optional[Date]
    def getLastStatus: ZIO[Any, AwsError, zio.aws.config.model.DeliveryStatus] =
      AwsError.unwrapOptionField("lastStatus", lastStatus)
    def getLastErrorCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastErrorCode", lastErrorCode)
    def getLastErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastErrorMessage", lastErrorMessage)
    def getLastAttemptTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastAttemptTime", lastAttemptTime)
    def getLastSuccessfulTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastSuccessfulTime", lastSuccessfulTime)
    def getNextDeliveryTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("nextDeliveryTime", nextDeliveryTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ConfigExportDeliveryInfo
  ) extends zio.aws.config.model.ConfigExportDeliveryInfo.ReadOnly {
    override val lastStatus: Optional[zio.aws.config.model.DeliveryStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastStatus())
        .map(value => zio.aws.config.model.DeliveryStatus.wrap(value))
    override val lastErrorCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.lastErrorCode())
      .map(value => value: String)
    override val lastErrorMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.lastErrorMessage())
      .map(value => value: String)
    override val lastAttemptTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastAttemptTime())
      .map(value => zio.aws.config.model.primitives.Date(value))
    override val lastSuccessfulTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastSuccessfulTime())
      .map(value => zio.aws.config.model.primitives.Date(value))
    override val nextDeliveryTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.nextDeliveryTime())
      .map(value => zio.aws.config.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ConfigExportDeliveryInfo
  ): zio.aws.config.model.ConfigExportDeliveryInfo.ReadOnly = new Wrapper(impl)
}
