package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Compliance(
    complianceType: Optional[zio.aws.config.model.ComplianceType] =
      Optional.Absent,
    complianceContributorCount: Optional[
      zio.aws.config.model.ComplianceContributorCount
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.Compliance = {
    import Compliance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.Compliance
      .builder()
      .optionallyWith(complianceType.map(value => value.unwrap))(
        _.complianceType
      )
      .optionallyWith(
        complianceContributorCount.map(value => value.buildAwsValue())
      )(_.complianceContributorCount)
      .build()
  }
  def asReadOnly: zio.aws.config.model.Compliance.ReadOnly =
    zio.aws.config.model.Compliance.wrap(buildAwsValue())
}
object Compliance {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.config.model.Compliance] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.Compliance =
      zio.aws.config.model.Compliance(
        complianceType.map(value => value),
        complianceContributorCount.map(value => value.asEditable)
      )
    def complianceType: Optional[zio.aws.config.model.ComplianceType]
    def complianceContributorCount
        : Optional[zio.aws.config.model.ComplianceContributorCount.ReadOnly]
    def getComplianceType
        : ZIO[Any, AwsError, zio.aws.config.model.ComplianceType] =
      AwsError.unwrapOptionField("complianceType", complianceType)
    def getComplianceContributorCount: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.ComplianceContributorCount.ReadOnly
    ] = AwsError.unwrapOptionField(
      "complianceContributorCount",
      complianceContributorCount
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.Compliance
  ) extends zio.aws.config.model.Compliance.ReadOnly {
    override val complianceType: Optional[zio.aws.config.model.ComplianceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.complianceType())
        .map(value => zio.aws.config.model.ComplianceType.wrap(value))
    override val complianceContributorCount
        : Optional[zio.aws.config.model.ComplianceContributorCount.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.complianceContributorCount())
        .map(value =>
          zio.aws.config.model.ComplianceContributorCount.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.Compliance
  ): zio.aws.config.model.Compliance.ReadOnly = new Wrapper(impl)
}
