package zio.aws.config.model
import scala.jdk.CollectionConverters.*
sealed trait SortBy {
  def unwrap: software.amazon.awssdk.services.config.model.SortBy
}
object SortBy {
  def wrap(
      value: software.amazon.awssdk.services.config.model.SortBy
  ): zio.aws.config.model.SortBy = value match {
    case software.amazon.awssdk.services.config.model.SortBy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.config.model.SortBy.SCORE =>
      val r = SCORE
      r
  }
  case object unknownToSdkVersion extends zio.aws.config.model.SortBy {
    override def unwrap: software.amazon.awssdk.services.config.model.SortBy =
      software.amazon.awssdk.services.config.model.SortBy.UNKNOWN_TO_SDK_VERSION
  }
  case object SCORE extends zio.aws.config.model.SortBy {
    override def unwrap: software.amazon.awssdk.services.config.model.SortBy =
      software.amazon.awssdk.services.config.model.SortBy.SCORE
  }
}
