package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutRetentionConfigurationResponse(
    retentionConfiguration: Optional[
      zio.aws.config.model.RetentionConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.PutRetentionConfigurationResponse = {
    import PutRetentionConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.PutRetentionConfigurationResponse
      .builder()
      .optionallyWith(
        retentionConfiguration.map(value => value.buildAwsValue())
      )(_.retentionConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.PutRetentionConfigurationResponse.ReadOnly =
    zio.aws.config.model.PutRetentionConfigurationResponse.wrap(buildAwsValue())
}
object PutRetentionConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.PutRetentionConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.PutRetentionConfigurationResponse =
      zio.aws.config.model.PutRetentionConfigurationResponse(
        retentionConfiguration.map(value => value.asEditable)
      )
    def retentionConfiguration
        : Optional[zio.aws.config.model.RetentionConfiguration.ReadOnly]
    def getRetentionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.RetentionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "retentionConfiguration",
      retentionConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.PutRetentionConfigurationResponse
  ) extends zio.aws.config.model.PutRetentionConfigurationResponse.ReadOnly {
    override val retentionConfiguration
        : Optional[zio.aws.config.model.RetentionConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retentionConfiguration())
        .map(value => zio.aws.config.model.RetentionConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.PutRetentionConfigurationResponse
  ): zio.aws.config.model.PutRetentionConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
