package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListDiscoveredResourcesResponse(
    resourceIdentifiers: Optional[
      Iterable[zio.aws.config.model.ResourceIdentifier]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ListDiscoveredResourcesResponse = {
    import ListDiscoveredResourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ListDiscoveredResourcesResponse
      .builder()
      .optionallyWith(
        resourceIdentifiers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceIdentifiers)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.ListDiscoveredResourcesResponse.ReadOnly =
    zio.aws.config.model.ListDiscoveredResourcesResponse.wrap(buildAwsValue())
}
object ListDiscoveredResourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ListDiscoveredResourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ListDiscoveredResourcesResponse =
      zio.aws.config.model.ListDiscoveredResourcesResponse(
        resourceIdentifiers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def resourceIdentifiers
        : Optional[List[zio.aws.config.model.ResourceIdentifier.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getResourceIdentifiers: ZIO[Any, AwsError, List[
      zio.aws.config.model.ResourceIdentifier.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceIdentifiers", resourceIdentifiers)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ListDiscoveredResourcesResponse
  ) extends zio.aws.config.model.ListDiscoveredResourcesResponse.ReadOnly {
    override val resourceIdentifiers
        : Optional[List[zio.aws.config.model.ResourceIdentifier.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceIdentifiers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.ResourceIdentifier.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.config.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ListDiscoveredResourcesResponse
  ): zio.aws.config.model.ListDiscoveredResourcesResponse.ReadOnly =
    new Wrapper(impl)
}
