package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{NextToken, ConformancePackName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetConformancePackComplianceDetailsResponse(
    conformancePackName: ConformancePackName,
    conformancePackRuleEvaluationResults: Optional[
      Iterable[zio.aws.config.model.ConformancePackEvaluationResult]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsResponse = {
    import GetConformancePackComplianceDetailsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsResponse
      .builder()
      .conformancePackName(
        ConformancePackName.unwrap(conformancePackName): java.lang.String
      )
      .optionallyWith(
        conformancePackRuleEvaluationResults.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.conformancePackRuleEvaluationResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.GetConformancePackComplianceDetailsResponse.ReadOnly =
    zio.aws.config.model.GetConformancePackComplianceDetailsResponse
      .wrap(buildAwsValue())
}
object GetConformancePackComplianceDetailsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.GetConformancePackComplianceDetailsResponse =
      zio.aws.config.model.GetConformancePackComplianceDetailsResponse(
        conformancePackName,
        conformancePackRuleEvaluationResults.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def conformancePackName: ConformancePackName
    def conformancePackRuleEvaluationResults: Optional[
      List[zio.aws.config.model.ConformancePackEvaluationResult.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getConformancePackName: ZIO[Any, Nothing, ConformancePackName] =
      ZIO.succeed(conformancePackName)
    def getConformancePackRuleEvaluationResults: ZIO[Any, AwsError, List[
      zio.aws.config.model.ConformancePackEvaluationResult.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "conformancePackRuleEvaluationResults",
      conformancePackRuleEvaluationResults
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsResponse
  ) extends zio.aws.config.model.GetConformancePackComplianceDetailsResponse.ReadOnly {
    override val conformancePackName: ConformancePackName =
      zio.aws.config.model.primitives
        .ConformancePackName(impl.conformancePackName())
    override val conformancePackRuleEvaluationResults: Optional[
      List[zio.aws.config.model.ConformancePackEvaluationResult.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.conformancePackRuleEvaluationResults())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.ConformancePackEvaluationResult.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.config.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsResponse
  ): zio.aws.config.model.GetConformancePackComplianceDetailsResponse.ReadOnly =
    new Wrapper(impl)
}
