package zio.aws.config.model
import scala.jdk.CollectionConverters.*
sealed trait EventSource {
  def unwrap: software.amazon.awssdk.services.config.model.EventSource
}
object EventSource {
  def wrap(
      value: software.amazon.awssdk.services.config.model.EventSource
  ): zio.aws.config.model.EventSource = value match {
    case software.amazon.awssdk.services.config.model.EventSource.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.config.model.EventSource.AWS_CONFIG =>
      val r = `aws.config`
      r
  }
  case object unknownToSdkVersion extends zio.aws.config.model.EventSource {
    override def unwrap
        : software.amazon.awssdk.services.config.model.EventSource =
      software.amazon.awssdk.services.config.model.EventSource.UNKNOWN_TO_SDK_VERSION
  }
  case object `aws.config` extends zio.aws.config.model.EventSource {
    override def unwrap
        : software.amazon.awssdk.services.config.model.EventSource =
      software.amazon.awssdk.services.config.model.EventSource.AWS_CONFIG
  }
}
