package zio.aws.config.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.config.model.primitives.{
  LastUpdatedTime,
  ConformancePackName,
  ComplianceScore
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ConformancePackComplianceScore(
    score: Optional[ComplianceScore] = Optional.Absent,
    conformancePackName: Optional[ConformancePackName] = Optional.Absent,
    lastUpdatedTime: Optional[LastUpdatedTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ConformancePackComplianceScore = {
    import ConformancePackComplianceScore.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ConformancePackComplianceScore
      .builder()
      .optionallyWith(
        score.map(value => ComplianceScore.unwrap(value): java.lang.String)
      )(_.score)
      .optionallyWith(
        conformancePackName.map(value =>
          ConformancePackName.unwrap(value): java.lang.String
        )
      )(_.conformancePackName)
      .optionallyWith(
        lastUpdatedTime.map(value => LastUpdatedTime.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .build()
  }
  def asReadOnly: zio.aws.config.model.ConformancePackComplianceScore.ReadOnly =
    zio.aws.config.model.ConformancePackComplianceScore.wrap(buildAwsValue())
}
object ConformancePackComplianceScore {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ConformancePackComplianceScore
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ConformancePackComplianceScore =
      zio.aws.config.model.ConformancePackComplianceScore(
        score.map(value => value),
        conformancePackName.map(value => value),
        lastUpdatedTime.map(value => value)
      )
    def score: Optional[ComplianceScore]
    def conformancePackName: Optional[ConformancePackName]
    def lastUpdatedTime: Optional[LastUpdatedTime]
    def getScore: ZIO[Any, AwsError, ComplianceScore] =
      AwsError.unwrapOptionField("score", score)
    def getConformancePackName: ZIO[Any, AwsError, ConformancePackName] =
      AwsError.unwrapOptionField("conformancePackName", conformancePackName)
    def getLastUpdatedTime: ZIO[Any, AwsError, LastUpdatedTime] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ConformancePackComplianceScore
  ) extends zio.aws.config.model.ConformancePackComplianceScore.ReadOnly {
    override val score: Optional[ComplianceScore] = zio.aws.core.internal
      .optionalFromNullable(impl.score())
      .map(value => zio.aws.config.model.primitives.ComplianceScore(value))
    override val conformancePackName: Optional[ConformancePackName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.conformancePackName())
        .map(value =>
          zio.aws.config.model.primitives.ConformancePackName(value)
        )
    override val lastUpdatedTime: Optional[LastUpdatedTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedTime())
        .map(value => zio.aws.config.model.primitives.LastUpdatedTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ConformancePackComplianceScore
  ): zio.aws.config.model.ConformancePackComplianceScore.ReadOnly = new Wrapper(
    impl
  )
}
