package zio.aws.config.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.config.model.primitives.Date
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class TimeWindow(
    startTime: Optional[Date] = Optional.Absent,
    endTime: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.TimeWindow = {
    import TimeWindow.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.TimeWindow
      .builder()
      .optionallyWith(startTime.map(value => Date.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Date.unwrap(value): Instant))(
        _.endTime
      )
      .build()
  }
  def asReadOnly: zio.aws.config.model.TimeWindow.ReadOnly =
    zio.aws.config.model.TimeWindow.wrap(buildAwsValue())
}
object TimeWindow {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.config.model.TimeWindow] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.TimeWindow = zio.aws.config.model
      .TimeWindow(startTime.map(value => value), endTime.map(value => value))
    def startTime: Optional[Date]
    def endTime: Optional[Date]
    def getStartTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("endTime", endTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.TimeWindow
  ) extends zio.aws.config.model.TimeWindow.ReadOnly {
    override val startTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.config.model.primitives.Date(value))
    override val endTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.config.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.TimeWindow
  ): zio.aws.config.model.TimeWindow.ReadOnly = new Wrapper(impl)
}
