package zio.aws.config.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.config.model.primitives.RecorderName
import scala.jdk.CollectionConverters.*
final case class StopConfigurationRecorderRequest(
    configurationRecorderName: RecorderName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.StopConfigurationRecorderRequest = {
    import StopConfigurationRecorderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.StopConfigurationRecorderRequest
      .builder()
      .configurationRecorderName(
        RecorderName.unwrap(configurationRecorderName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.StopConfigurationRecorderRequest.ReadOnly =
    zio.aws.config.model.StopConfigurationRecorderRequest.wrap(buildAwsValue())
}
object StopConfigurationRecorderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.StopConfigurationRecorderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.StopConfigurationRecorderRequest =
      zio.aws.config.model
        .StopConfigurationRecorderRequest(configurationRecorderName)
    def configurationRecorderName: RecorderName
    def getConfigurationRecorderName: ZIO[Any, Nothing, RecorderName] =
      ZIO.succeed(configurationRecorderName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.StopConfigurationRecorderRequest
  ) extends zio.aws.config.model.StopConfigurationRecorderRequest.ReadOnly {
    override val configurationRecorderName: RecorderName =
      zio.aws.config.model.primitives
        .RecorderName(impl.configurationRecorderName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.StopConfigurationRecorderRequest
  ): zio.aws.config.model.StopConfigurationRecorderRequest.ReadOnly =
    new Wrapper(impl)
}
