package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{
  BaseResourceId,
  StringWithCharLimit128,
  StringWithCharLimit256
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Scope(
    complianceResourceTypes: Optional[Iterable[StringWithCharLimit256]] =
      Optional.Absent,
    tagKey: Optional[StringWithCharLimit128] = Optional.Absent,
    tagValue: Optional[StringWithCharLimit256] = Optional.Absent,
    complianceResourceId: Optional[BaseResourceId] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.config.model.Scope = {
    import Scope.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.Scope
      .builder()
      .optionallyWith(
        complianceResourceTypes.map(value =>
          value.map { item =>
            StringWithCharLimit256.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.complianceResourceTypes)
      .optionallyWith(
        tagKey.map(value =>
          StringWithCharLimit128.unwrap(value): java.lang.String
        )
      )(_.tagKey)
      .optionallyWith(
        tagValue.map(value =>
          StringWithCharLimit256.unwrap(value): java.lang.String
        )
      )(_.tagValue)
      .optionallyWith(
        complianceResourceId.map(value =>
          BaseResourceId.unwrap(value): java.lang.String
        )
      )(_.complianceResourceId)
      .build()
  }
  def asReadOnly: zio.aws.config.model.Scope.ReadOnly =
    zio.aws.config.model.Scope.wrap(buildAwsValue())
}
object Scope {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.config.model.Scope] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.Scope = zio.aws.config.model.Scope(
      complianceResourceTypes.map(value => value),
      tagKey.map(value => value),
      tagValue.map(value => value),
      complianceResourceId.map(value => value)
    )
    def complianceResourceTypes: Optional[List[StringWithCharLimit256]]
    def tagKey: Optional[StringWithCharLimit128]
    def tagValue: Optional[StringWithCharLimit256]
    def complianceResourceId: Optional[BaseResourceId]
    def getComplianceResourceTypes
        : ZIO[Any, AwsError, List[StringWithCharLimit256]] = AwsError
      .unwrapOptionField("complianceResourceTypes", complianceResourceTypes)
    def getTagKey: ZIO[Any, AwsError, StringWithCharLimit128] =
      AwsError.unwrapOptionField("tagKey", tagKey)
    def getTagValue: ZIO[Any, AwsError, StringWithCharLimit256] =
      AwsError.unwrapOptionField("tagValue", tagValue)
    def getComplianceResourceId: ZIO[Any, AwsError, BaseResourceId] =
      AwsError.unwrapOptionField("complianceResourceId", complianceResourceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.Scope
  ) extends zio.aws.config.model.Scope.ReadOnly {
    override val complianceResourceTypes
        : Optional[List[StringWithCharLimit256]] = zio.aws.core.internal
      .optionalFromNullable(impl.complianceResourceTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.primitives.StringWithCharLimit256(item)
        }.toList
      )
    override val tagKey: Optional[StringWithCharLimit128] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagKey())
        .map(value =>
          zio.aws.config.model.primitives.StringWithCharLimit128(value)
        )
    override val tagValue: Optional[StringWithCharLimit256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagValue())
        .map(value =>
          zio.aws.config.model.primitives.StringWithCharLimit256(value)
        )
    override val complianceResourceId: Optional[BaseResourceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.complianceResourceId())
        .map(value => zio.aws.config.model.primitives.BaseResourceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.Scope
  ): zio.aws.config.model.Scope.ReadOnly = new Wrapper(impl)
}
