package zio.aws.config.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.config.model.primitives.ChannelName
import scala.jdk.CollectionConverters.*
final case class DeleteDeliveryChannelRequest(
    deliveryChannelName: ChannelName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DeleteDeliveryChannelRequest = {
    import DeleteDeliveryChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DeleteDeliveryChannelRequest
      .builder()
      .deliveryChannelName(
        ChannelName.unwrap(deliveryChannelName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.config.model.DeleteDeliveryChannelRequest.ReadOnly =
    zio.aws.config.model.DeleteDeliveryChannelRequest.wrap(buildAwsValue())
}
object DeleteDeliveryChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DeleteDeliveryChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.DeleteDeliveryChannelRequest =
      zio.aws.config.model.DeleteDeliveryChannelRequest(deliveryChannelName)
    def deliveryChannelName: ChannelName
    def getDeliveryChannelName: ZIO[Any, Nothing, ChannelName] =
      ZIO.succeed(deliveryChannelName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DeleteDeliveryChannelRequest
  ) extends zio.aws.config.model.DeleteDeliveryChannelRequest.ReadOnly {
    override val deliveryChannelName: ChannelName =
      zio.aws.config.model.primitives.ChannelName(impl.deliveryChannelName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DeleteDeliveryChannelRequest
  ): zio.aws.config.model.DeleteDeliveryChannelRequest.ReadOnly = new Wrapper(
    impl
  )
}
