package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SelectResourceConfigResponse(
    results: Optional[Iterable[String]] = Optional.Absent,
    queryInfo: Optional[zio.aws.config.model.QueryInfo] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.SelectResourceConfigResponse = {
    import SelectResourceConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.SelectResourceConfigResponse
      .builder()
      .optionallyWith(
        results.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.results)
      .optionallyWith(queryInfo.map(value => value.buildAwsValue()))(
        _.queryInfo
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.config.model.SelectResourceConfigResponse.ReadOnly =
    zio.aws.config.model.SelectResourceConfigResponse.wrap(buildAwsValue())
}
object SelectResourceConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.SelectResourceConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.SelectResourceConfigResponse =
      zio.aws.config.model.SelectResourceConfigResponse(
        results.map(value => value),
        queryInfo.map(value => value.asEditable),
        nextToken.map(value => value)
      )
    def results: Optional[List[String]]
    def queryInfo: Optional[zio.aws.config.model.QueryInfo.ReadOnly]
    def nextToken: Optional[NextToken]
    def getResults: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("results", results)
    def getQueryInfo
        : ZIO[Any, AwsError, zio.aws.config.model.QueryInfo.ReadOnly] =
      AwsError.unwrapOptionField("queryInfo", queryInfo)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.SelectResourceConfigResponse
  ) extends zio.aws.config.model.SelectResourceConfigResponse.ReadOnly {
    override val results: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.results())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val queryInfo: Optional[zio.aws.config.model.QueryInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queryInfo())
        .map(value => zio.aws.config.model.QueryInfo.wrap(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.config.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.SelectResourceConfigResponse
  ): zio.aws.config.model.SelectResourceConfigResponse.ReadOnly = new Wrapper(
    impl
  )
}
