package zio.aws.config.model
import zio.prelude.data.Optional
import zio.aws.config.model.primitives.{
  NextToken,
  Limit,
  StringWithCharLimit256
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetDiscoveredResourceCountsRequest(
    resourceTypes: Optional[Iterable[StringWithCharLimit256]] = Optional.Absent,
    limit: Optional[Limit] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsRequest = {
    import GetDiscoveredResourceCountsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsRequest
      .builder()
      .optionallyWith(
        resourceTypes.map(value =>
          value.map { item =>
            StringWithCharLimit256.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.resourceTypes)
      .optionallyWith(limit.map(value => Limit.unwrap(value): Integer))(_.limit)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.GetDiscoveredResourceCountsRequest.ReadOnly =
    zio.aws.config.model.GetDiscoveredResourceCountsRequest
      .wrap(buildAwsValue())
}
object GetDiscoveredResourceCountsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.GetDiscoveredResourceCountsRequest =
      zio.aws.config.model.GetDiscoveredResourceCountsRequest(
        resourceTypes.map(value => value),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def resourceTypes: Optional[List[StringWithCharLimit256]]
    def limit: Optional[Limit]
    def nextToken: Optional[NextToken]
    def getResourceTypes: ZIO[Any, AwsError, List[StringWithCharLimit256]] =
      AwsError.unwrapOptionField("resourceTypes", resourceTypes)
    def getLimit: ZIO[Any, AwsError, Limit] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsRequest
  ) extends zio.aws.config.model.GetDiscoveredResourceCountsRequest.ReadOnly {
    override val resourceTypes: Optional[List[StringWithCharLimit256]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.primitives.StringWithCharLimit256(item)
          }.toList
        )
    override val limit: Optional[Limit] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.config.model.primitives.Limit(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.config.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsRequest
  ): zio.aws.config.model.GetDiscoveredResourceCountsRequest.ReadOnly =
    new Wrapper(impl)
}
