package zio.aws.config.model
import scala.jdk.CollectionConverters.*
sealed trait SortOrder {
  def unwrap: software.amazon.awssdk.services.config.model.SortOrder
}
object SortOrder {
  def wrap(
      value: software.amazon.awssdk.services.config.model.SortOrder
  ): zio.aws.config.model.SortOrder = value match {
    case software.amazon.awssdk.services.config.model.SortOrder.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.config.model.SortOrder.ASCENDING =>
      val r = ASCENDING
      r
    case software.amazon.awssdk.services.config.model.SortOrder.DESCENDING =>
      val r = DESCENDING
      r
  }
  case object unknownToSdkVersion extends zio.aws.config.model.SortOrder {
    override def unwrap
        : software.amazon.awssdk.services.config.model.SortOrder =
      software.amazon.awssdk.services.config.model.SortOrder.UNKNOWN_TO_SDK_VERSION
  }
  case object ASCENDING extends zio.aws.config.model.SortOrder {
    override def unwrap
        : software.amazon.awssdk.services.config.model.SortOrder =
      software.amazon.awssdk.services.config.model.SortOrder.ASCENDING
  }
  case object DESCENDING extends zio.aws.config.model.SortOrder {
    override def unwrap
        : software.amazon.awssdk.services.config.model.SortOrder =
      software.amazon.awssdk.services.config.model.SortOrder.DESCENDING
  }
}
