package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeConfigurationRecorderStatusResponse(
    configurationRecordersStatus: Optional[
      Iterable[zio.aws.config.model.ConfigurationRecorderStatus]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeConfigurationRecorderStatusResponse = {
    import DescribeConfigurationRecorderStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeConfigurationRecorderStatusResponse
      .builder()
      .optionallyWith(
        configurationRecordersStatus.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.configurationRecordersStatus)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeConfigurationRecorderStatusResponse.ReadOnly =
    zio.aws.config.model.DescribeConfigurationRecorderStatusResponse
      .wrap(buildAwsValue())
}
object DescribeConfigurationRecorderStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeConfigurationRecorderStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.DescribeConfigurationRecorderStatusResponse =
      zio.aws.config.model.DescribeConfigurationRecorderStatusResponse(
        configurationRecordersStatus.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def configurationRecordersStatus: Optional[
      List[zio.aws.config.model.ConfigurationRecorderStatus.ReadOnly]
    ]
    def getConfigurationRecordersStatus: ZIO[Any, AwsError, List[
      zio.aws.config.model.ConfigurationRecorderStatus.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "configurationRecordersStatus",
      configurationRecordersStatus
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeConfigurationRecorderStatusResponse
  ) extends zio.aws.config.model.DescribeConfigurationRecorderStatusResponse.ReadOnly {
    override val configurationRecordersStatus: Optional[
      List[zio.aws.config.model.ConfigurationRecorderStatus.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.configurationRecordersStatus())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.ConfigurationRecorderStatus.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeConfigurationRecorderStatusResponse
  ): zio.aws.config.model.DescribeConfigurationRecorderStatusResponse.ReadOnly =
    new Wrapper(impl)
}
