package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeComplianceByConfigRuleResponse(
    complianceByConfigRules: Optional[
      Iterable[zio.aws.config.model.ComplianceByConfigRule]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleResponse = {
    import DescribeComplianceByConfigRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleResponse
      .builder()
      .optionallyWith(
        complianceByConfigRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.complianceByConfigRules)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeComplianceByConfigRuleResponse.ReadOnly =
    zio.aws.config.model.DescribeComplianceByConfigRuleResponse
      .wrap(buildAwsValue())
}
object DescribeComplianceByConfigRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.DescribeComplianceByConfigRuleResponse =
      zio.aws.config.model.DescribeComplianceByConfigRuleResponse(
        complianceByConfigRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def complianceByConfigRules
        : Optional[List[zio.aws.config.model.ComplianceByConfigRule.ReadOnly]]
    def nextToken: Optional[String]
    def getComplianceByConfigRules: ZIO[Any, AwsError, List[
      zio.aws.config.model.ComplianceByConfigRule.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "complianceByConfigRules",
      complianceByConfigRules
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleResponse
  ) extends zio.aws.config.model.DescribeComplianceByConfigRuleResponse.ReadOnly {
    override val complianceByConfigRules
        : Optional[List[zio.aws.config.model.ComplianceByConfigRule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.complianceByConfigRules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.ComplianceByConfigRule.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleResponse
  ): zio.aws.config.model.DescribeComplianceByConfigRuleResponse.ReadOnly =
    new Wrapper(impl)
}
