package zio.aws.config.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.config.model.primitives.RecorderName
import scala.jdk.CollectionConverters.*
final case class StartConfigurationRecorderRequest(
    configurationRecorderName: RecorderName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.StartConfigurationRecorderRequest = {
    import StartConfigurationRecorderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.StartConfigurationRecorderRequest
      .builder()
      .configurationRecorderName(
        RecorderName.unwrap(configurationRecorderName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.StartConfigurationRecorderRequest.ReadOnly =
    zio.aws.config.model.StartConfigurationRecorderRequest.wrap(buildAwsValue())
}
object StartConfigurationRecorderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.StartConfigurationRecorderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.StartConfigurationRecorderRequest =
      zio.aws.config.model
        .StartConfigurationRecorderRequest(configurationRecorderName)
    def configurationRecorderName: RecorderName
    def getConfigurationRecorderName: ZIO[Any, Nothing, RecorderName] =
      ZIO.succeed(configurationRecorderName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.StartConfigurationRecorderRequest
  ) extends zio.aws.config.model.StartConfigurationRecorderRequest.ReadOnly {
    override val configurationRecorderName: RecorderName =
      zio.aws.config.model.primitives
        .RecorderName(impl.configurationRecorderName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.StartConfigurationRecorderRequest
  ): zio.aws.config.model.StartConfigurationRecorderRequest.ReadOnly =
    new Wrapper(impl)
}
