package zio.aws.config.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.config.model.primitives.{
  NextToken,
  EarlierTime,
  Limit,
  ResourceId,
  LaterTime
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetResourceConfigHistoryRequest(
    resourceType: zio.aws.config.model.ResourceType,
    resourceId: ResourceId,
    laterTime: Optional[LaterTime] = Optional.Absent,
    earlierTime: Optional[EarlierTime] = Optional.Absent,
    chronologicalOrder: Optional[zio.aws.config.model.ChronologicalOrder] =
      Optional.Absent,
    limit: Optional[Limit] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.GetResourceConfigHistoryRequest = {
    import GetResourceConfigHistoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.GetResourceConfigHistoryRequest
      .builder()
      .resourceType(resourceType.unwrap)
      .resourceId(ResourceId.unwrap(resourceId): java.lang.String)
      .optionallyWith(laterTime.map(value => LaterTime.unwrap(value): Instant))(
        _.laterTime
      )
      .optionallyWith(
        earlierTime.map(value => EarlierTime.unwrap(value): Instant)
      )(_.earlierTime)
      .optionallyWith(chronologicalOrder.map(value => value.unwrap))(
        _.chronologicalOrder
      )
      .optionallyWith(limit.map(value => Limit.unwrap(value): Integer))(_.limit)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.GetResourceConfigHistoryRequest.ReadOnly =
    zio.aws.config.model.GetResourceConfigHistoryRequest.wrap(buildAwsValue())
}
object GetResourceConfigHistoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.GetResourceConfigHistoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.GetResourceConfigHistoryRequest =
      zio.aws.config.model.GetResourceConfigHistoryRequest(
        resourceType,
        resourceId,
        laterTime.map(value => value),
        earlierTime.map(value => value),
        chronologicalOrder.map(value => value),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def resourceType: zio.aws.config.model.ResourceType
    def resourceId: ResourceId
    def laterTime: Optional[LaterTime]
    def earlierTime: Optional[EarlierTime]
    def chronologicalOrder: Optional[zio.aws.config.model.ChronologicalOrder]
    def limit: Optional[Limit]
    def nextToken: Optional[NextToken]
    def getResourceType: ZIO[Any, Nothing, zio.aws.config.model.ResourceType] =
      ZIO.succeed(resourceType)
    def getResourceId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(resourceId)
    def getLaterTime: ZIO[Any, AwsError, LaterTime] =
      AwsError.unwrapOptionField("laterTime", laterTime)
    def getEarlierTime: ZIO[Any, AwsError, EarlierTime] =
      AwsError.unwrapOptionField("earlierTime", earlierTime)
    def getChronologicalOrder
        : ZIO[Any, AwsError, zio.aws.config.model.ChronologicalOrder] =
      AwsError.unwrapOptionField("chronologicalOrder", chronologicalOrder)
    def getLimit: ZIO[Any, AwsError, Limit] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.GetResourceConfigHistoryRequest
  ) extends zio.aws.config.model.GetResourceConfigHistoryRequest.ReadOnly {
    override val resourceType: zio.aws.config.model.ResourceType =
      zio.aws.config.model.ResourceType.wrap(impl.resourceType())
    override val resourceId: ResourceId =
      zio.aws.config.model.primitives.ResourceId(impl.resourceId())
    override val laterTime: Optional[LaterTime] = zio.aws.core.internal
      .optionalFromNullable(impl.laterTime())
      .map(value => zio.aws.config.model.primitives.LaterTime(value))
    override val earlierTime: Optional[EarlierTime] = zio.aws.core.internal
      .optionalFromNullable(impl.earlierTime())
      .map(value => zio.aws.config.model.primitives.EarlierTime(value))
    override val chronologicalOrder
        : Optional[zio.aws.config.model.ChronologicalOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.chronologicalOrder())
        .map(value => zio.aws.config.model.ChronologicalOrder.wrap(value))
    override val limit: Optional[Limit] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.config.model.primitives.Limit(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.config.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.GetResourceConfigHistoryRequest
  ): zio.aws.config.model.GetResourceConfigHistoryRequest.ReadOnly =
    new Wrapper(impl)
}
