package zio.aws.config.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.config.model.primitives.RecorderName
import scala.jdk.CollectionConverters.*
final case class DeleteConfigurationRecorderRequest(
    configurationRecorderName: RecorderName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DeleteConfigurationRecorderRequest = {
    import DeleteConfigurationRecorderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DeleteConfigurationRecorderRequest
      .builder()
      .configurationRecorderName(
        RecorderName.unwrap(configurationRecorderName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DeleteConfigurationRecorderRequest.ReadOnly =
    zio.aws.config.model.DeleteConfigurationRecorderRequest
      .wrap(buildAwsValue())
}
object DeleteConfigurationRecorderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DeleteConfigurationRecorderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.DeleteConfigurationRecorderRequest =
      zio.aws.config.model
        .DeleteConfigurationRecorderRequest(configurationRecorderName)
    def configurationRecorderName: RecorderName
    def getConfigurationRecorderName: ZIO[Any, Nothing, RecorderName] =
      ZIO.succeed(configurationRecorderName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DeleteConfigurationRecorderRequest
  ) extends zio.aws.config.model.DeleteConfigurationRecorderRequest.ReadOnly {
    override val configurationRecorderName: RecorderName =
      zio.aws.config.model.primitives
        .RecorderName(impl.configurationRecorderName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DeleteConfigurationRecorderRequest
  ): zio.aws.config.model.DeleteConfigurationRecorderRequest.ReadOnly =
    new Wrapper(impl)
}
