package zio.aws.config.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.config.model.primitives.ConformancePackName
import scala.jdk.CollectionConverters.*
final case class ConformancePackComplianceScoresFilters(
    conformancePackNames: Iterable[ConformancePackName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ConformancePackComplianceScoresFilters = {
    import ConformancePackComplianceScoresFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ConformancePackComplianceScoresFilters
      .builder()
      .conformancePackNames(conformancePackNames.map { item =>
        ConformancePackName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.ConformancePackComplianceScoresFilters.ReadOnly =
    zio.aws.config.model.ConformancePackComplianceScoresFilters
      .wrap(buildAwsValue())
}
object ConformancePackComplianceScoresFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ConformancePackComplianceScoresFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.ConformancePackComplianceScoresFilters =
      zio.aws.config.model
        .ConformancePackComplianceScoresFilters(conformancePackNames)
    def conformancePackNames: List[ConformancePackName]
    def getConformancePackNames: ZIO[Any, Nothing, List[ConformancePackName]] =
      ZIO.succeed(conformancePackNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ConformancePackComplianceScoresFilters
  ) extends zio.aws.config.model.ConformancePackComplianceScoresFilters.ReadOnly {
    override val conformancePackNames: List[ConformancePackName] = impl
      .conformancePackNames()
      .asScala
      .map { item =>
        zio.aws.config.model.primitives.ConformancePackName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ConformancePackComplianceScoresFilters
  ): zio.aws.config.model.ConformancePackComplianceScoresFilters.ReadOnly =
    new Wrapper(impl)
}
