package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchGetResourceConfigResponse(
    baseConfigurationItems: Optional[
      Iterable[zio.aws.config.model.BaseConfigurationItem]
    ] = Optional.Absent,
    unprocessedResourceKeys: Optional[
      Iterable[zio.aws.config.model.ResourceKey]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.BatchGetResourceConfigResponse = {
    import BatchGetResourceConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.BatchGetResourceConfigResponse
      .builder()
      .optionallyWith(
        baseConfigurationItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.baseConfigurationItems)
      .optionallyWith(
        unprocessedResourceKeys.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unprocessedResourceKeys)
      .build()
  }
  def asReadOnly: zio.aws.config.model.BatchGetResourceConfigResponse.ReadOnly =
    zio.aws.config.model.BatchGetResourceConfigResponse.wrap(buildAwsValue())
}
object BatchGetResourceConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.BatchGetResourceConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.BatchGetResourceConfigResponse =
      zio.aws.config.model.BatchGetResourceConfigResponse(
        baseConfigurationItems.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        unprocessedResourceKeys.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def baseConfigurationItems
        : Optional[List[zio.aws.config.model.BaseConfigurationItem.ReadOnly]]
    def unprocessedResourceKeys
        : Optional[List[zio.aws.config.model.ResourceKey.ReadOnly]]
    def getBaseConfigurationItems: ZIO[Any, AwsError, List[
      zio.aws.config.model.BaseConfigurationItem.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "baseConfigurationItems",
      baseConfigurationItems
    )
    def getUnprocessedResourceKeys
        : ZIO[Any, AwsError, List[zio.aws.config.model.ResourceKey.ReadOnly]] =
      AwsError.unwrapOptionField(
        "unprocessedResourceKeys",
        unprocessedResourceKeys
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.BatchGetResourceConfigResponse
  ) extends zio.aws.config.model.BatchGetResourceConfigResponse.ReadOnly {
    override val baseConfigurationItems
        : Optional[List[zio.aws.config.model.BaseConfigurationItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.baseConfigurationItems())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.BaseConfigurationItem.wrap(item)
          }.toList
        )
    override val unprocessedResourceKeys
        : Optional[List[zio.aws.config.model.ResourceKey.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unprocessedResourceKeys())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.ResourceKey.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.BatchGetResourceConfigResponse
  ): zio.aws.config.model.BatchGetResourceConfigResponse.ReadOnly = new Wrapper(
    impl
  )
}
