package zio.aws.config.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.config.model.primitives.{ResourceId, ResourceTypeString}
import scala.jdk.CollectionConverters.*
final case class DeleteResourceConfigRequest(
    resourceType: ResourceTypeString,
    resourceId: ResourceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DeleteResourceConfigRequest = {
    import DeleteResourceConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DeleteResourceConfigRequest
      .builder()
      .resourceType(ResourceTypeString.unwrap(resourceType): java.lang.String)
      .resourceId(ResourceId.unwrap(resourceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.config.model.DeleteResourceConfigRequest.ReadOnly =
    zio.aws.config.model.DeleteResourceConfigRequest.wrap(buildAwsValue())
}
object DeleteResourceConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DeleteResourceConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.DeleteResourceConfigRequest =
      zio.aws.config.model.DeleteResourceConfigRequest(resourceType, resourceId)
    def resourceType: ResourceTypeString
    def resourceId: ResourceId
    def getResourceType: ZIO[Any, Nothing, ResourceTypeString] =
      ZIO.succeed(resourceType)
    def getResourceId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(resourceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DeleteResourceConfigRequest
  ) extends zio.aws.config.model.DeleteResourceConfigRequest.ReadOnly {
    override val resourceType: ResourceTypeString =
      zio.aws.config.model.primitives.ResourceTypeString(impl.resourceType())
    override val resourceId: ResourceId =
      zio.aws.config.model.primitives.ResourceId(impl.resourceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DeleteResourceConfigRequest
  ): zio.aws.config.model.DeleteResourceConfigRequest.ReadOnly = new Wrapper(
    impl
  )
}
