package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RemediationParameterValue(
    resourceValue: Optional[zio.aws.config.model.ResourceValue] =
      Optional.Absent,
    staticValue: Optional[zio.aws.config.model.StaticValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.RemediationParameterValue = {
    import RemediationParameterValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.RemediationParameterValue
      .builder()
      .optionallyWith(resourceValue.map(value => value.buildAwsValue()))(
        _.resourceValue
      )
      .optionallyWith(staticValue.map(value => value.buildAwsValue()))(
        _.staticValue
      )
      .build()
  }
  def asReadOnly: zio.aws.config.model.RemediationParameterValue.ReadOnly =
    zio.aws.config.model.RemediationParameterValue.wrap(buildAwsValue())
}
object RemediationParameterValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.RemediationParameterValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.RemediationParameterValue =
      zio.aws.config.model.RemediationParameterValue(
        resourceValue.map(value => value.asEditable),
        staticValue.map(value => value.asEditable)
      )
    def resourceValue: Optional[zio.aws.config.model.ResourceValue.ReadOnly]
    def staticValue: Optional[zio.aws.config.model.StaticValue.ReadOnly]
    def getResourceValue
        : ZIO[Any, AwsError, zio.aws.config.model.ResourceValue.ReadOnly] =
      AwsError.unwrapOptionField("resourceValue", resourceValue)
    def getStaticValue
        : ZIO[Any, AwsError, zio.aws.config.model.StaticValue.ReadOnly] =
      AwsError.unwrapOptionField("staticValue", staticValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.RemediationParameterValue
  ) extends zio.aws.config.model.RemediationParameterValue.ReadOnly {
    override val resourceValue
        : Optional[zio.aws.config.model.ResourceValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceValue())
        .map(value => zio.aws.config.model.ResourceValue.wrap(value))
    override val staticValue
        : Optional[zio.aws.config.model.StaticValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.staticValue())
        .map(value => zio.aws.config.model.StaticValue.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.RemediationParameterValue
  ): zio.aws.config.model.RemediationParameterValue.ReadOnly = new Wrapper(impl)
}
