package zio.aws.config.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.config.model.primitives.RetentionPeriodInDays
import scala.jdk.CollectionConverters.*
final case class PutRetentionConfigurationRequest(
    retentionPeriodInDays: RetentionPeriodInDays
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.PutRetentionConfigurationRequest = {
    import PutRetentionConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.PutRetentionConfigurationRequest
      .builder()
      .retentionPeriodInDays(
        RetentionPeriodInDays.unwrap(retentionPeriodInDays): Integer
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.PutRetentionConfigurationRequest.ReadOnly =
    zio.aws.config.model.PutRetentionConfigurationRequest.wrap(buildAwsValue())
}
object PutRetentionConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.PutRetentionConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.PutRetentionConfigurationRequest =
      zio.aws.config.model
        .PutRetentionConfigurationRequest(retentionPeriodInDays)
    def retentionPeriodInDays: RetentionPeriodInDays
    def getRetentionPeriodInDays: ZIO[Any, Nothing, RetentionPeriodInDays] =
      ZIO.succeed(retentionPeriodInDays)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.PutRetentionConfigurationRequest
  ) extends zio.aws.config.model.PutRetentionConfigurationRequest.ReadOnly {
    override val retentionPeriodInDays: RetentionPeriodInDays =
      zio.aws.config.model.primitives
        .RetentionPeriodInDays(impl.retentionPeriodInDays())
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.PutRetentionConfigurationRequest
  ): zio.aws.config.model.PutRetentionConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
