package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{NextToken, StringWithCharLimit256}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetAggregateConfigRuleComplianceSummaryResponse(
    groupByKey: Optional[StringWithCharLimit256] = Optional.Absent,
    aggregateComplianceCounts: Optional[
      Iterable[zio.aws.config.model.AggregateComplianceCount]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryResponse = {
    import GetAggregateConfigRuleComplianceSummaryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryResponse
      .builder()
      .optionallyWith(
        groupByKey.map(value =>
          StringWithCharLimit256.unwrap(value): java.lang.String
        )
      )(_.groupByKey)
      .optionallyWith(
        aggregateComplianceCounts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.aggregateComplianceCounts)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.GetAggregateConfigRuleComplianceSummaryResponse.ReadOnly =
    zio.aws.config.model.GetAggregateConfigRuleComplianceSummaryResponse
      .wrap(buildAwsValue())
}
object GetAggregateConfigRuleComplianceSummaryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.GetAggregateConfigRuleComplianceSummaryResponse =
      zio.aws.config.model.GetAggregateConfigRuleComplianceSummaryResponse(
        groupByKey.map(value => value),
        aggregateComplianceCounts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def groupByKey: Optional[StringWithCharLimit256]
    def aggregateComplianceCounts
        : Optional[List[zio.aws.config.model.AggregateComplianceCount.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getGroupByKey: ZIO[Any, AwsError, StringWithCharLimit256] =
      AwsError.unwrapOptionField("groupByKey", groupByKey)
    def getAggregateComplianceCounts: ZIO[Any, AwsError, List[
      zio.aws.config.model.AggregateComplianceCount.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "aggregateComplianceCounts",
      aggregateComplianceCounts
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryResponse
  ) extends zio.aws.config.model.GetAggregateConfigRuleComplianceSummaryResponse.ReadOnly {
    override val groupByKey: Optional[StringWithCharLimit256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groupByKey())
        .map(value =>
          zio.aws.config.model.primitives.StringWithCharLimit256(value)
        )
    override val aggregateComplianceCounts: Optional[
      List[zio.aws.config.model.AggregateComplianceCount.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.aggregateComplianceCounts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.AggregateComplianceCount.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.config.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryResponse
  ): zio.aws.config.model.GetAggregateConfigRuleComplianceSummaryResponse.ReadOnly =
    new Wrapper(impl)
}
