package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.ConfigurationAggregatorName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutConfigurationAggregatorRequest(
    configurationAggregatorName: ConfigurationAggregatorName,
    accountAggregationSources: Optional[
      Iterable[zio.aws.config.model.AccountAggregationSource]
    ] = Optional.Absent,
    organizationAggregationSource: Optional[
      zio.aws.config.model.OrganizationAggregationSource
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.config.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.PutConfigurationAggregatorRequest = {
    import PutConfigurationAggregatorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.PutConfigurationAggregatorRequest
      .builder()
      .configurationAggregatorName(
        ConfigurationAggregatorName.unwrap(
          configurationAggregatorName
        ): java.lang.String
      )
      .optionallyWith(
        accountAggregationSources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accountAggregationSources)
      .optionallyWith(
        organizationAggregationSource.map(value => value.buildAwsValue())
      )(_.organizationAggregationSource)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.PutConfigurationAggregatorRequest.ReadOnly =
    zio.aws.config.model.PutConfigurationAggregatorRequest.wrap(buildAwsValue())
}
object PutConfigurationAggregatorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.PutConfigurationAggregatorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.PutConfigurationAggregatorRequest =
      zio.aws.config.model.PutConfigurationAggregatorRequest(
        configurationAggregatorName,
        accountAggregationSources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        organizationAggregationSource.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def configurationAggregatorName: ConfigurationAggregatorName
    def accountAggregationSources
        : Optional[List[zio.aws.config.model.AccountAggregationSource.ReadOnly]]
    def organizationAggregationSource
        : Optional[zio.aws.config.model.OrganizationAggregationSource.ReadOnly]
    def tags: Optional[List[zio.aws.config.model.Tag.ReadOnly]]
    def getConfigurationAggregatorName
        : ZIO[Any, Nothing, ConfigurationAggregatorName] =
      ZIO.succeed(configurationAggregatorName)
    def getAccountAggregationSources: ZIO[Any, AwsError, List[
      zio.aws.config.model.AccountAggregationSource.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "accountAggregationSources",
      accountAggregationSources
    )
    def getOrganizationAggregationSource: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.OrganizationAggregationSource.ReadOnly
    ] = AwsError.unwrapOptionField(
      "organizationAggregationSource",
      organizationAggregationSource
    )
    def getTags: ZIO[Any, AwsError, List[zio.aws.config.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.PutConfigurationAggregatorRequest
  ) extends zio.aws.config.model.PutConfigurationAggregatorRequest.ReadOnly {
    override val configurationAggregatorName: ConfigurationAggregatorName =
      zio.aws.config.model.primitives
        .ConfigurationAggregatorName(impl.configurationAggregatorName())
    override val accountAggregationSources: Optional[
      List[zio.aws.config.model.AccountAggregationSource.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.accountAggregationSources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.AccountAggregationSource.wrap(item)
        }.toList
      )
    override val organizationAggregationSource: Optional[
      zio.aws.config.model.OrganizationAggregationSource.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.organizationAggregationSource())
      .map(value =>
        zio.aws.config.model.OrganizationAggregationSource.wrap(value)
      )
    override val tags: Optional[List[zio.aws.config.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.PutConfigurationAggregatorRequest
  ): zio.aws.config.model.PutConfigurationAggregatorRequest.ReadOnly =
    new Wrapper(impl)
}
