package zio.aws.config.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.config.model.primitives.{Date, AwsRegion}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class AggregatedSourceStatus(
    sourceId: Optional[String] = Optional.Absent,
    sourceType: Optional[zio.aws.config.model.AggregatedSourceType] =
      Optional.Absent,
    awsRegion: Optional[AwsRegion] = Optional.Absent,
    lastUpdateStatus: Optional[
      zio.aws.config.model.AggregatedSourceStatusType
    ] = Optional.Absent,
    lastUpdateTime: Optional[Date] = Optional.Absent,
    lastErrorCode: Optional[String] = Optional.Absent,
    lastErrorMessage: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.AggregatedSourceStatus = {
    import AggregatedSourceStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.AggregatedSourceStatus
      .builder()
      .optionallyWith(sourceId.map(value => value: java.lang.String))(
        _.sourceId
      )
      .optionallyWith(sourceType.map(value => value.unwrap))(_.sourceType)
      .optionallyWith(
        awsRegion.map(value => AwsRegion.unwrap(value): java.lang.String)
      )(_.awsRegion)
      .optionallyWith(lastUpdateStatus.map(value => value.unwrap))(
        _.lastUpdateStatus
      )
      .optionallyWith(lastUpdateTime.map(value => Date.unwrap(value): Instant))(
        _.lastUpdateTime
      )
      .optionallyWith(lastErrorCode.map(value => value: java.lang.String))(
        _.lastErrorCode
      )
      .optionallyWith(lastErrorMessage.map(value => value: java.lang.String))(
        _.lastErrorMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.config.model.AggregatedSourceStatus.ReadOnly =
    zio.aws.config.model.AggregatedSourceStatus.wrap(buildAwsValue())
}
object AggregatedSourceStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.AggregatedSourceStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.AggregatedSourceStatus =
      zio.aws.config.model.AggregatedSourceStatus(
        sourceId.map(value => value),
        sourceType.map(value => value),
        awsRegion.map(value => value),
        lastUpdateStatus.map(value => value),
        lastUpdateTime.map(value => value),
        lastErrorCode.map(value => value),
        lastErrorMessage.map(value => value)
      )
    def sourceId: Optional[String]
    def sourceType: Optional[zio.aws.config.model.AggregatedSourceType]
    def awsRegion: Optional[AwsRegion]
    def lastUpdateStatus
        : Optional[zio.aws.config.model.AggregatedSourceStatusType]
    def lastUpdateTime: Optional[Date]
    def lastErrorCode: Optional[String]
    def lastErrorMessage: Optional[String]
    def getSourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceId", sourceId)
    def getSourceType
        : ZIO[Any, AwsError, zio.aws.config.model.AggregatedSourceType] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getAwsRegion: ZIO[Any, AwsError, AwsRegion] =
      AwsError.unwrapOptionField("awsRegion", awsRegion)
    def getLastUpdateStatus
        : ZIO[Any, AwsError, zio.aws.config.model.AggregatedSourceStatusType] =
      AwsError.unwrapOptionField("lastUpdateStatus", lastUpdateStatus)
    def getLastUpdateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdateTime", lastUpdateTime)
    def getLastErrorCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastErrorCode", lastErrorCode)
    def getLastErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastErrorMessage", lastErrorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.AggregatedSourceStatus
  ) extends zio.aws.config.model.AggregatedSourceStatus.ReadOnly {
    override val sourceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceId())
      .map(value => value: String)
    override val sourceType
        : Optional[zio.aws.config.model.AggregatedSourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceType())
        .map(value => zio.aws.config.model.AggregatedSourceType.wrap(value))
    override val awsRegion: Optional[AwsRegion] = zio.aws.core.internal
      .optionalFromNullable(impl.awsRegion())
      .map(value => zio.aws.config.model.primitives.AwsRegion(value))
    override val lastUpdateStatus
        : Optional[zio.aws.config.model.AggregatedSourceStatusType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdateStatus())
        .map(value =>
          zio.aws.config.model.AggregatedSourceStatusType.wrap(value)
        )
    override val lastUpdateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdateTime())
      .map(value => zio.aws.config.model.primitives.Date(value))
    override val lastErrorCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.lastErrorCode())
      .map(value => value: String)
    override val lastErrorMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.lastErrorMessage())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.AggregatedSourceStatus
  ): zio.aws.config.model.AggregatedSourceStatus.ReadOnly = new Wrapper(impl)
}
