package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetConformancePackComplianceSummaryResponse(
    conformancePackComplianceSummaryList: Optional[
      Iterable[zio.aws.config.model.ConformancePackComplianceSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryResponse = {
    import GetConformancePackComplianceSummaryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryResponse
      .builder()
      .optionallyWith(
        conformancePackComplianceSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.conformancePackComplianceSummaryList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.GetConformancePackComplianceSummaryResponse.ReadOnly =
    zio.aws.config.model.GetConformancePackComplianceSummaryResponse
      .wrap(buildAwsValue())
}
object GetConformancePackComplianceSummaryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.GetConformancePackComplianceSummaryResponse =
      zio.aws.config.model.GetConformancePackComplianceSummaryResponse(
        conformancePackComplianceSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def conformancePackComplianceSummaryList: Optional[
      List[zio.aws.config.model.ConformancePackComplianceSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getConformancePackComplianceSummaryList: ZIO[Any, AwsError, List[
      zio.aws.config.model.ConformancePackComplianceSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "conformancePackComplianceSummaryList",
      conformancePackComplianceSummaryList
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryResponse
  ) extends zio.aws.config.model.GetConformancePackComplianceSummaryResponse.ReadOnly {
    override val conformancePackComplianceSummaryList: Optional[
      List[zio.aws.config.model.ConformancePackComplianceSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.conformancePackComplianceSummaryList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.ConformancePackComplianceSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.config.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryResponse
  ): zio.aws.config.model.GetConformancePackComplianceSummaryResponse.ReadOnly =
    new Wrapper(impl)
}
