package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{
  AwsRegion,
  AccountId,
  ConformancePackName
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AggregateComplianceByConformancePack(
    conformancePackName: Optional[ConformancePackName] = Optional.Absent,
    compliance: Optional[
      zio.aws.config.model.AggregateConformancePackCompliance
    ] = Optional.Absent,
    accountId: Optional[AccountId] = Optional.Absent,
    awsRegion: Optional[AwsRegion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.AggregateComplianceByConformancePack = {
    import AggregateComplianceByConformancePack.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.AggregateComplianceByConformancePack
      .builder()
      .optionallyWith(
        conformancePackName.map(value =>
          ConformancePackName.unwrap(value): java.lang.String
        )
      )(_.conformancePackName)
      .optionallyWith(compliance.map(value => value.buildAwsValue()))(
        _.compliance
      )
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        awsRegion.map(value => AwsRegion.unwrap(value): java.lang.String)
      )(_.awsRegion)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.AggregateComplianceByConformancePack.ReadOnly =
    zio.aws.config.model.AggregateComplianceByConformancePack
      .wrap(buildAwsValue())
}
object AggregateComplianceByConformancePack {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.AggregateComplianceByConformancePack
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.AggregateComplianceByConformancePack =
      zio.aws.config.model.AggregateComplianceByConformancePack(
        conformancePackName.map(value => value),
        compliance.map(value => value.asEditable),
        accountId.map(value => value),
        awsRegion.map(value => value)
      )
    def conformancePackName: Optional[ConformancePackName]
    def compliance: Optional[
      zio.aws.config.model.AggregateConformancePackCompliance.ReadOnly
    ]
    def accountId: Optional[AccountId]
    def awsRegion: Optional[AwsRegion]
    def getConformancePackName: ZIO[Any, AwsError, ConformancePackName] =
      AwsError.unwrapOptionField("conformancePackName", conformancePackName)
    def getCompliance: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.AggregateConformancePackCompliance.ReadOnly
    ] = AwsError.unwrapOptionField("compliance", compliance)
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getAwsRegion: ZIO[Any, AwsError, AwsRegion] =
      AwsError.unwrapOptionField("awsRegion", awsRegion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.AggregateComplianceByConformancePack
  ) extends zio.aws.config.model.AggregateComplianceByConformancePack.ReadOnly {
    override val conformancePackName: Optional[ConformancePackName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.conformancePackName())
        .map(value =>
          zio.aws.config.model.primitives.ConformancePackName(value)
        )
    override val compliance: Optional[
      zio.aws.config.model.AggregateConformancePackCompliance.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.compliance())
      .map(value =>
        zio.aws.config.model.AggregateConformancePackCompliance.wrap(value)
      )
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.config.model.primitives.AccountId(value))
    override val awsRegion: Optional[AwsRegion] = zio.aws.core.internal
      .optionalFromNullable(impl.awsRegion())
      .map(value => zio.aws.config.model.primitives.AwsRegion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.AggregateComplianceByConformancePack
  ): zio.aws.config.model.AggregateComplianceByConformancePack.ReadOnly =
    new Wrapper(impl)
}
