package zio.aws.config.model
import scala.jdk.CollectionConverters.*
sealed trait ResourceCountGroupKey {
  def unwrap: software.amazon.awssdk.services.config.model.ResourceCountGroupKey
}
object ResourceCountGroupKey {
  def wrap(
      value: software.amazon.awssdk.services.config.model.ResourceCountGroupKey
  ): zio.aws.config.model.ResourceCountGroupKey = value match {
    case software.amazon.awssdk.services.config.model.ResourceCountGroupKey.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.config.model.ResourceCountGroupKey.RESOURCE_TYPE =>
      val r = RESOURCE_TYPE
      r
    case software.amazon.awssdk.services.config.model.ResourceCountGroupKey.ACCOUNT_ID =>
      val r = ACCOUNT_ID
      r
    case software.amazon.awssdk.services.config.model.ResourceCountGroupKey.AWS_REGION =>
      val r = AWS_REGION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.config.model.ResourceCountGroupKey {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceCountGroupKey =
      software.amazon.awssdk.services.config.model.ResourceCountGroupKey.UNKNOWN_TO_SDK_VERSION
  }
  case object RESOURCE_TYPE extends zio.aws.config.model.ResourceCountGroupKey {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceCountGroupKey =
      software.amazon.awssdk.services.config.model.ResourceCountGroupKey.RESOURCE_TYPE
  }
  case object ACCOUNT_ID extends zio.aws.config.model.ResourceCountGroupKey {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceCountGroupKey =
      software.amazon.awssdk.services.config.model.ResourceCountGroupKey.ACCOUNT_ID
  }
  case object AWS_REGION extends zio.aws.config.model.ResourceCountGroupKey {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceCountGroupKey =
      software.amazon.awssdk.services.config.model.ResourceCountGroupKey.AWS_REGION
  }
}
